# V2 Present‑Act Complementarity Simulation

This repository contains a self‑contained Python script for reproducing the
complementarity curve experiment described in the “present‑act V2” theory. The
simulation demonstrates the trade‑off between fringe visibility and which‑path
distinguishability in a two‑slit setup using a binary meter. The experiment
ensures that the complementarity relation

\[ V(\alpha)^2 + D(\alpha)^2 \approx 1 \]

is saturated by implementing a simple, discrete model of the quantum two‑slit
interference. The meter’s overlap parameter \(\alpha\) controls how much
information is gained about which slit a particle traverses, with values
ranging from 0 (no interference) to 1 (full interference).

## Files

- `run_simulation.py` — the main script that runs the simulation. It outputs
  two CSV files (`complementarity_curve.csv` and `meter_conditionals.csv`) and
  two JSON files (`complementarity_summary.json` and `audit.json`).
- `requirements.txt` — minimal dependencies required to run the script.
- `README.md` — this file.

## Requirements

The script depends on the following Python libraries:

- `numpy`
- `pandas`

You can install these using pip:

```bash
pip install -r requirements.txt
```

## Usage

To run the simulation, navigate to the repository directory and execute:

```bash
python run_simulation.py
```

By default, the script simulates 50,000 trials per meter setting `α` for three
different random seeds and sweeps `α` from 0.00 to 1.00 in steps of 0.05.
It writes four output files to the current working directory:

- **complementarity_curve.csv** — contains the measured visibility (`vis`),
  normalized visibility (`vis_norm`), observed distinguishability (`d_obs`),
  predicted values (`V_pred` and `D_pred`), complementarity residual and
  neutral rate for each `α`.
- **meter_conditionals.csv** — reports the empirical conditional probabilities
  `P(m=1 | U)` and `P(m=1 | L)` along with the count of `U` and `L`
  trajectories per `α`.
- **complementarity_summary.json** — summary statistics including RMSE
  comparisons and monotonicity checks.
- **audit.json** — a record of the guardrails enforced (all set to `true`).

After running the script, the console will display the contents of
`complementarity_summary.json`, summarizing the RMSE values, maximum
complementarity residual, and whether the qualitative monotonicity checks
passed.

## Customizing the Simulation

The simulation can be customized by modifying the `simulate` function in
`run_simulation.py`. You can adjust:

- The set of `α` values to sweep.
- The list of random seeds to aggregate.
- The number of trials per `α` per seed.
- The output directory into which results are written.

For example:

```python
from pathlib import Path
from run_simulation import simulate

# Sweep α at finer resolution and use more trials
alphas = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
seeds = [111, 222, 333]
trials = 100000
output = Path("results")
output.mkdir(exist_ok=True)
curve_df, meter_df = simulate(alpha_values=alphas, seeds=seeds,
                               trials_per_alpha=trials, output_dir=output)
```

will produce files in a `results/` directory with the custom parameters.

## Contact

For questions about this simulation or the underlying theory, please refer to
the original documentation provided with the present‑act V2 project.
